#pragma once
#include <algorithm>
#include <functional>
#include <Mswsock.h>

#include "Log.h"

class WorkerTask: public AC::Runnable
{
protected:
	AC::TcpClient m_ClientSocket;
	AC::tstring m_RootDir;

	AC::tstring FormatThreadMessage(AC::tstring Message)
	{
		SYSTEMTIME LocalTime;
		AC::tostringstream os;
		const int DateWidth = 2;

		GetLocalTime(&LocalTime);
		os << _T("[") << std::setfill(_T('0')) << std::setw(DateWidth) << LocalTime.wHour
			<< _T(":") << std::setfill(_T('0')) << std::setw(DateWidth) << LocalTime.wMinute
			<< _T(":") << std::setfill(_T('0')) << std::setw(DateWidth) << LocalTime.wSecond
			<< _T("]") << _T(" - Thread ") << GetCurrentThreadId() << _T(": ") << Message;

		return os.str();
	}

	void AddMessage(AC::tstring Message)
	{
		Log::Instance().AddMessage(FormatThreadMessage(Message));
	}

	void AddError(AC::tstring Error)
	{
		Log::Instance().AddError(FormatThreadMessage(Error));
	}

	AC::tstring GetRequest(AC::TcpClient ServiceSocket)
	{
		const char* HTTPEndRequest = "\r\n\r\n";

		// Se recibe la peticin HTTP
		std::string Request = ServiceSocket.RecvLine(HTTPEndRequest);

		// Se convierte a cadena Unicode
		AC::tstring WideRequest = AnsiTotstring(Request.c_str());

		// Para mostrarlo por pantalla se cambia el caracter de salto de lnea por //*{\rmfamily\textparagraph} 
		// (ASCII 182)
		const int LineBreakChar = 182;
		replace_if(WideRequest.begin(), WideRequest.end(), bind2nd(std::equal_to<char>(),
			'\r'), LineBreakChar);
		
		// Log de la peticin
		AddMessage(WideRequest.c_str());

		return WideRequest;
	}

	void ServeRequest(AC::TcpClient ServiceSocket, AC::tstring Request)
	{
		const LPCTSTR AllowedRequestType = _T("GET");

		// Buscar el tipo de peticin
		size_t FirstSpacePos = Request.find(_T(" "), 0);
		if (FirstSpacePos == std::string::npos)
			throw AC::Exception() << _T("Invalid request");

		// Comprobar si la peticin es de tipo AllowedRequestType
		if (Request.substr(0, FirstSpacePos -1) == AllowedRequestType)
			throw AC::Exception() << _T("Request type '") 
			<< AllowedRequestType << _T("' not allowed");

		// Buscar el nombre del fichero
		size_t SecondSpacePos = Request.find(_T(" "), FirstSpacePos + 1);
		AC::tstring FileRequested = Request.substr(FirstSpacePos + 1, 
			SecondSpacePos - FirstSpacePos - 1);

		// Enviar el fichero a travs del socket
		SendFile(ServiceSocket, FileRequested);
	}

	void SendFile(AC::TcpClient ServiceSocket, AC::tstring FileRequested)
	{
		AC::tstring FullFileName = m_RootDir + FileRequested;
		HANDLE hFile;

		hFile = CreateFile(FullFileName.c_str(), GENERIC_READ,0,NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			throw AC::Exception() << AC::StrError(GetLastError());

		// Enviar el archivo a travs del handle hFile utilizando la funcin
		// TransmitFile y comprobar los errores
		Completar
		CloseHandle(hFile);
	}

public:
	WorkerTask(AC::TcpClient ClientSocket, AC::tstring RootDir)
		:m_ClientSocket(ClientSocket), m_RootDir(RootDir) {}

	void Run()
	{
		try
		{
			AC::tostringstream oss;
			oss << 	_T("Request from ") << m_ClientSocket.GetPeerName();
			AddMessage(oss.str());

			// Recibir y servir la peticin
			Completar		
		}
		catch(std::exception& ex)
		{
			AC::tstring Reason = AnsiTotstring(ex.what());
			AddError(Reason.c_str());
		}
		m_ClientSocket.Close();
	}
};