// WebServer.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "WebServer.h"
#include "MainWindow.h"
#include "LibraryLoader.h"

#include "../LibAC/Src/ScopedWinSock.h"

#pragma comment(lib, "WS2_32.LIB") // WinSock
#pragma comment(lib, "Mswsock.lib") // TransmitFile

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hInstance);
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	try
	{
		AC::ScopedWinSock UsingWinSock;
		AC::LibraryLoader Load(_T("riched20.DLL"));

		MainWindow MainWin;
		MainWin.Create();
		MainWin.ShowWindow(nCmdShow);

		BOOL bRet;
		MSG msg;
		while((bRet = GetMessage(&msg, NULL, 0, 0)) != 0)
		{
		    if (bRet == -1)
				throw AC::Exception() << AC::StrError(GetLastError());

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		return (int)msg.wParam;
	}
	catch(std::exception& ex)
	{
		AC::tstring Reason = AnsiTotstring(ex.what());
		MessageBox(NULL, Reason.c_str(), _T("Application failure"), MB_OK|MB_ICONERROR);
		return EXIT_FAILURE;
	}
}
