#pragma once
#include "../LibAC/Src/Window.h"
#include "../LibAC/Src/TcpListener.h"
#include "../LibAC/Src/ThreadPool.h"

#include "LogControl.h"
#include "Log.h"

#include "AboutDialog.h"
#include "ConfigureDialog.h"
#include "HTTPD.h"

#define MAX_LOADSTRING 100

class MainWindow : public AC::Window
{
	AC::LogControl m_LogControl;
	HTTPD* m_pHTTPD;
	HTTPDOptions m_HTTPD_Options;

protected:
	virtual LRESULT OnWmCreate(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		m_LogControl.Create(this, IDC_LOGCONTROL);
		Log::Instance().SetLogControl(&m_LogControl);
		m_pHTTPD = NULL;
		return 0;
	}

	void StartServer()
	{
		if (m_pHTTPD == NULL)
		{
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_START, MF_DISABLED|MF_GRAYED);
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_CONFIGURE, MF_DISABLED|MF_GRAYED);
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_STOP, MF_ENABLED);
			m_pHTTPD = new HTTPD(m_HTTPD_Options);
		}
	}

	void StopServer()
	{
		if (m_pHTTPD != NULL)
		{
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_START, MF_ENABLED);
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_CONFIGURE, MF_ENABLED);
			EnableMenuItem(GetMenu(m_hWnd), ID_FILE_STOP, MF_DISABLED|MF_GRAYED);
			delete m_pHTTPD;
			m_pHTTPD = NULL;
		}
	}

	virtual LRESULT OnWmDestroy(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		PostQuitMessage(0);
		return 0;
	}

	// Para evitar el parpadeo del fondo al redimensionar
	virtual LRESULT OnEraseBkgnd(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		return 0;
	}

	virtual LRESULT OnExit(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		SendMessage(*this, WM_CLOSE, 0, 0);
		return 0;
	}

	virtual LRESULT OnClose(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		StopServer();
		DestroyWindow();
		return 0;
	}

	LRESULT OnSize(WPARAM /*wParam*/, LPARAM lParam)
	{
		MoveWindow(m_LogControl, 0, 0,
			LOWORD(lParam), // Ancho
			HIWORD(lParam),	// Alto
			FALSE);
		return 0;
	}

	virtual LRESULT OnFileStart(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		StartServer();
		return 0;
	}

	virtual LRESULT OnFileStop(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		StopServer();
		return 0;
	}

	virtual LRESULT OnFileConfigure(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		ConfigureDialog ConfigureDlg(m_HTTPD_Options);
		if (ConfigureDlg.DoModal(*this, GetModuleHandle(NULL)) == IDOK)
			m_HTTPD_Options = ConfigureDlg.GetOptions();
		return 0;
	}

	virtual LRESULT OnHelpAbout(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		AboutDialog AboutDlg;
		AboutDlg.DoModal(*this, GetModuleHandle(NULL));
		return 0;
	}

public:
	MainWindow(void)
	{
		AddMessageHandler(WM_CREATE, static_cast<MsgHandler>(&MainWindow::OnWmCreate));
		AddMessageHandler(WM_DESTROY, static_cast<MsgHandler>(&MainWindow::OnWmDestroy));
		AddMessageHandler(WM_ERASEBKGND, static_cast<MsgHandler>(&MainWindow::OnEraseBkgnd));
		AddMessageHandler(WM_SIZE, static_cast<MsgHandler>(&MainWindow::OnSize));
		AddMessageHandler(WM_CLOSE, static_cast<MsgHandler>(&MainWindow::OnClose));

		AddMessageHandler(WM_COMMAND, static_cast<MsgHandler>(&MainWindow::OnExit), 
			IDM_EXIT, BN_CLICKED);
		AddMessageHandler(WM_COMMAND, static_cast<MsgHandler>(&MainWindow::OnFileStart), 
			ID_FILE_START, BN_CLICKED);
		AddMessageHandler(WM_COMMAND, static_cast<MsgHandler>(&MainWindow::OnFileStop), 
			ID_FILE_STOP, BN_CLICKED);
		AddMessageHandler(WM_COMMAND, static_cast<MsgHandler>(&MainWindow::OnFileConfigure), 
			ID_FILE_CONFIGURE, BN_CLICKED);
		AddMessageHandler(WM_COMMAND, static_cast<MsgHandler>(&MainWindow::OnHelpAbout), 
			IDM_ABOUT, BN_CLICKED);
	}

	~MainWindow(void) {}

	void Create()
	{
		TCHAR szTitle[MAX_LOADSTRING];
		TCHAR szWindowClass[MAX_LOADSTRING];

		LoadString(GetModuleHandle(NULL), IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
		LoadString(GetModuleHandle(NULL), IDC_WEBSERVER, szWindowClass, MAX_LOADSTRING);

		Window::RegisterClass(GetModuleHandle(NULL), szWindowClass, IDC_WEBSERVER);
		Window::Create(GetModuleHandle(NULL), szWindowClass, szTitle);
	}
};
