#pragma once
#include "../LibAC/Src/Window.h"
#include "../LibAC/Src/tstring.h"
#include "../LibAC/Src/ScopedCriticalSection.h"

namespace AC
{
	class LogControl :
		public AC::Window
	{
	protected:
		COLORREF m_MessageColor;
		COLORREF m_ErrorColor;

		AC::CriticalSection m_LogControlLock;

		virtual void AddTextLine(AC::tstring TextLine, COLORREF Color);

		static LPCTSTR DefaultFontName;
		static const int DefaultFontSize;
		static const COLORREF DefaultMessageColor;
		static const COLORREF DefaultErrorColor;

	public:
		LogControl(void);
		~LogControl(void);

		void Create(AC::Window* Parent, UINT nID = 100);

		void AddMessage(AC::tstring Message);
		void AddError(AC::tstring Error);

		// Borra el contenido
		void Clear();

		// Establece el tipo y el tamao de la fuente en puntos
		void SetFont(LPCTSTR FontName, int FontSize);

		// Para cambiar los colores por defecto
		void SetMessageColor(COLORREF c)		{ m_MessageColor = c; }
		void SetErrorColor(COLORREF c)			{ m_ErrorColor = c; }
	};
}