#include "StdAfx.h"
#include "LogControl.h"
#include <richedit.h>
#include <iomanip>

namespace AC
{
	LPCTSTR LogControl::DefaultFontName = _T("Courier new");
	const int LogControl::DefaultFontSize = 10;
	const COLORREF LogControl::DefaultMessageColor = RGB(0, 0, 0);
	const COLORREF LogControl::DefaultErrorColor = RGB(154, 0, 0);

	LogControl::LogControl(void)
	{
		m_MessageColor = DefaultMessageColor;
		m_ErrorColor = DefaultErrorColor;
	}

	LogControl::~LogControl(void)
	{
	}

	void LogControl::Create(AC::Window* Parent, UINT nID /* = 100 */)
	{
		Window::Create(GetModuleHandle(NULL), RICHEDIT_CLASS, _T(""), 
			WS_VISIBLE | WS_CHILD | WS_BORDER | ES_MULTILINE 
			| ES_AUTOVSCROLL | ES_READONLY | WS_VSCROLL  | WS_HSCROLL,
			0, 0, 0, 0, *Parent, nID);

		// Para aumentar el lmite ms all de 64K
		::SendMessage(m_hWnd, EM_LIMITTEXT, 0xFFFFFFFF, 0);

		// Establece la fuente por defecto
		SetFont(DefaultFontName, DefaultFontSize);
	}

	void LogControl::AddTextLine(AC::tstring TextLine, COLORREF Color)
	{
		AC::ScopedCriticalSection ScopedLock(m_LogControlLock);

		int iTotalTextLength;
		AC::tstring FullTextLine;
		CHARRANGE cr = {};
		CHARFORMAT cf = {};

		iTotalTextLength = GetWindowTextLength(m_hWnd);
		cr.cpMin = iTotalTextLength;
		cr.cpMax = iTotalTextLength;
		::SendMessage(m_hWnd, EM_EXSETSEL, 0, (LPARAM)&cr);

		cf.cbSize = sizeof(cf);
		cf.dwMask = CFM_COLOR;
		cf.crTextColor = Color;
		::SendMessage(m_hWnd, EM_SETCHARFORMAT, SCF_SELECTION,  (LPARAM)&cf);

		FullTextLine = TextLine;

		// La primera lnea no lleva salto de lnea
		if (iTotalTextLength != 0)
			FullTextLine.insert(0, _T("\n"));

		// Por si hay \r\n
		size_t EndPos = FullTextLine.find(_T("\r\n"), 0);
		if (EndPos != std::string::npos)
			FullTextLine.replace(EndPos, FullTextLine.size(), _T(""));

		::SendMessage(m_hWnd, EM_REPLACESEL, 0, (LPARAM)FullTextLine.c_str());

		iTotalTextLength = GetWindowTextLength(m_hWnd);
		cr.cpMin = iTotalTextLength;
		cr.cpMax = iTotalTextLength;
		::SendMessage(m_hWnd, EM_EXSETSEL, 0, (LPARAM)&cr);

		::SendMessage(m_hWnd, EM_SCROLLCARET, 0, (LPARAM)&cr);
		SetFocus(m_hWnd);
	}

	void LogControl::AddMessage(AC::tstring Message)
	{
		AddTextLine(Message, m_MessageColor);
	}

	void LogControl::AddError(AC::tstring Error)
	{
		AddTextLine(Error, m_ErrorColor);
	}

	void LogControl::SetFont(LPCTSTR FontName, int FontSize)
	{
		CHARFORMAT cf = {};

		cf.cbSize = sizeof cf;
		cf.dwMask = CFM_FACE | CFM_SIZE;
		lstrcpy(cf.szFaceName, FontName); 
		cf.yHeight = FontSize*20;

		::SendMessage(m_hWnd, EM_SETCHARFORMAT, SCF_ALL,  (LPARAM)&cf);
	}

	void LogControl::Clear()
	{
		SetWindowText(m_hWnd, _T(""));
	}
}