#pragma once
#include "LogControl.h"

// Implementa el patrn de diseo singleton para ser accesible desde todo el cdigo
// http://en.wikipedia.org/wiki/Singleton_pattern
class Log
{
protected:
	Log() {}; 
	~Log() {} 
	Log(Log const&) {};
	Log& operator=(Log const&) {};

	AC::LogControl* m_LogControl;

public:

	static Log& Instance()
	{
		static Log log;
		return log;
	}

	void SetLogControl(AC::LogControl *LogCtrl)
	{
		m_LogControl = LogCtrl;
	}

	void AddMessage(AC::tstring msg)
	{
		m_LogControl->AddMessage(msg);
	}

	void AddError(AC::tstring err)
	{
		m_LogControl->AddError(err);
	}
};
