#pragma once

#include "Log.h"
#include "HTTPDOptions.h"
#include "WorkerTask.h"

#include "../LibAC/Src/ThreadPool.h"
#include "../LibAC/Src/Event.h"

class ListenerTask: public AC::Runnable
{
protected:
	HTTPDOptions m_Options;
	AC::Event m_StopEvent;

	// Tamao de la cola de peticiones en funcin del nmero de hilos
	static const int QueueFactor = 10;

public:
	ListenerTask(HTTPDOptions Options, AC::Event StopEvent)
		:m_Options(Options), m_StopEvent(StopEvent) {}

	void Run()
	{
		// Se crea el pool de hilos
		// Nmero de hilos: m_Options.GetNumThreads()
		// Tamao de la cola: m_Options.GetNumThreads() * QueueFactor
		Completar

		// Se establece la direccin de escucha
		AC::InetAddress ListenAddress(m_Options.GetListenPort());

		// Se crea el socket de escucha
		Completar

		// SocketEvent se activar cuando haya una conexin
		AC::Event SocketEvent;
		ListenerSocket.EventSelect(SocketEvent, FD_ACCEPT);

		std::vector<HANDLE> Events;
		Events.push_back(SocketEvent);
		Events.push_back(m_StopEvent);

		Log::Instance().AddMessage(_T("ListenerTask waiting for connections"));
		for (;;)
		{
			// Se espera por el FD_ACCEPT o por la activacin de m_StopEvent
			DWORD SignaledEventId;
			SignaledEventId = WaitForMultipleObjects(Events.size(), &Events[0], FALSE, INFINITE);

			switch (SignaledEventId)
			{
			case WAIT_OBJECT_0: // FD_ACCEPT
			{
				// Se reseta el evento
				WSANETWORKEVENTS NetworkEvents;
				ListenerSocket.EnumNetworkEvents(SocketEvent, &NetworkEvents);

				// Se acepta la conexin
				Completar

				// Se convierte el socket a bloqueante
				ClientSocket.EventSelect(NULL, 0);
				ClientSocket.SetBlocking(TRUE);

				// Se aade una nueva tarea al pool de hilos
				Completar

				break;
			}
			case WAIT_OBJECT_0 + 1: // m_StopEvent
				Log::Instance().AddMessage(_T("ListenerTask shutting down"));
				return;
			case WAIT_FAILED:
				Log::Instance().AddError(AC::StrError(GetLastError()));
				return;
			}
		}
	}
};