#pragma once

#include <Windows.h>

#include "../LibAC/Src/Exception.h"

namespace AC
{
	class LibraryLoader
	{
	protected:
		HINSTANCE m_hInst;

	public:
		LibraryLoader(AC::tstring LibraryName)
		{
			m_hInst = LoadLibrary(LibraryName.c_str());
			if (m_hInst == NULL)
				throw AC::Exception() << AC::StrError(GetLastError());
		}

		~LibraryLoader(void)
		{
			FreeLibrary(m_hInst);
		}
	};
}