#pragma once

#include "HTTPDOptions.h"
#include "ListenerTask.h"

class HTTPD
{
protected:
	// m_StopEvent se debe definir antes de m_ListenerThread, para que su constructor	
	// se ejecute antes. m_ListenerThread lo necesita construido cuando lo recibe
	AC::Event m_StopEvent;
	AC::Thread m_ListenerThread;

public:
	HTTPD(HTTPDOptions Options)
		:m_StopEvent(FALSE, TRUE), m_ListenerThread(new ListenerTask(Options, m_StopEvent))
	{
		m_ListenerThread.Start();
	}

	~HTTPD()
	{
		// Activar el evento que indica a m_ListenerThread que debe terminar
		m_StopEvent.SetEvent();

		// Esperar a que m_ListenerThread se termine
		// Se siguen procesando mensajes para que los hilos puedan aadir mensajes 
		// al log antes de morir
		while (m_ListenerThread.Wait(0) != WAIT_OBJECT_0)
		{
			static MSG msg;
			while (::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				GetMessage(&msg, NULL, 0, 0);
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} 
	}
};