#pragma once
#include "../AC/LogControl.h"
#include <sstream>
#include <string>
#include <iomanip>

class FTPLogControl :
	public AC::LogControl
{
protected:
	static const COLORREF CommandColor = RGB(0, 0, 0);
	static const COLORREF ReplyColor = RGB(0, 154, 0);

	std::string GetTimeStr()
	{
		std::string TimeString;
		SYSTEMTIME LocalTime;
		std::ostringstream TimeStringStream;

		GetLocalTime(&LocalTime);
		TimeStringStream << "[";
		TimeStringStream <<	std::setfill('0') << std::setw(2) << LocalTime.wHour << ":"; 
		TimeStringStream <<	std::setfill('0') << std::setw(2) << LocalTime.wMinute << ":";
		TimeStringStream <<	std::setfill('0') << std::setw(2) << LocalTime.wSecond << "] ";
		TimeString = TimeStringStream.str();

		return TimeString;
	}

	virtual void AddTextLine(AC::tstring TextLine, COLORREF Color)
	{
		std::string FullTextLine = GetTimeStr();
		FullTextLine += TextLine;

		LogControl::AddTextLine(FullTextLine, Color);
	}

public:
	FTPLogControl()
	{
		SetMessageColor(RGB(127, 127, 127));
		SetErrorColor(RGB(154, 0, 0));
	}

	void AddCommand(AC::tstring Command)
	{
		AddTextLine(Command, CommandColor);
	}

	void AddReply(AC::tstring Command)
	{
		AddTextLine(Command, ReplyColor);
	}
};
