#pragma once

#include "../LibAC/Src/Dialog.h"
#include "../LibAC/Src/tstring.h"

#include "HTTPDOptions.h"
#include "Resource.h"

class ConfigureDialog: public AC::Dialog
{
protected:
	HTTPDOptions m_Options;

	LRESULT OnWmInitdialog(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		SetDlgItemInt(m_hWnd, IDC_LISTENING_PORT, m_Options.GetListenPort(), FALSE);
		SetDlgItemInt(m_hWnd, IDC_NUM_THREADS, m_Options.GetNumThreads(), FALSE);
		SetDlgItemText(m_hWnd, IDC_ROOT_DIRECTORY, m_Options.GetRootDir().c_str());
		return TRUE;
	}

	LRESULT OnOK(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		BOOL Translation;

		int ListenPort = GetDlgItemInt(m_hWnd, IDC_LISTENING_PORT, &Translation, FALSE);
		if (!Translation)
		{
			MessageBox(m_hWnd, _T("Invalid listening port"), 
				_T("Configuration error"), MB_OK|MB_ICONERROR);
			return FALSE;
		}
		if (ListenPort > USHRT_MAX)
		{
			MessageBox(m_hWnd, _T("Invalid listening port"), 
				_T("Configuration Error"), MB_OK|MB_ICONERROR);
			return FALSE;
		}
		m_Options.SetListenPort((unsigned short)ListenPort);

		int NumThreads = GetDlgItemInt(m_hWnd, IDC_NUM_THREADS, &Translation, FALSE);
		if (!Translation)
		{
			MessageBox(m_hWnd, _T("Invalid number of threads"), 
				_T("Configuration error"), MB_OK|MB_ICONERROR);
			return FALSE;
		}
		m_Options.SetNumThreads(NumThreads);

		TCHAR Buffer[MAX_PATH];
		GetDlgItemText(*this, IDC_ROOT_DIRECTORY, Buffer, MAX_PATH);	
		m_Options.SetRootDir(Buffer);
		if (m_Options.GetRootDir().empty())
		{
			MessageBox(m_hWnd, _T("Invalid root directory"), 
				_T("Configuration error"), MB_OK|MB_ICONERROR);
			return FALSE;
		}

		EndDialog(IDOK);
		return TRUE;
	}

	LRESULT OnCancel(WPARAM /*wParam*/, LPARAM /*lParam*/)
	{
		EndDialog(IDCANCEL);
		return TRUE;
	}

public:
	ConfigureDialog(HTTPDOptions Options)
		:Dialog(IDD_CONFIGUREBOX), m_Options(Options)
	{
		AddMessageHandler(WM_INITDIALOG, 
			static_cast<MsgHandler>(&ConfigureDialog::OnWmInitdialog));

		AddMessageHandler(WM_COMMAND, 
			static_cast<MsgHandler>(&ConfigureDialog::OnOK), IDOK, BN_CLICKED);
		AddMessageHandler(WM_COMMAND, 
			static_cast<MsgHandler>(&ConfigureDialog::OnCancel), IDCANCEL, BN_CLICKED);
	}

	HTTPDOptions GetOptions() { return m_Options; }
};